using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

// Example submitted by StJo

namespace XMLEditor
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItemFile;
		private System.Windows.Forms.MenuItem menuItemNew;
		private System.Windows.Forms.MenuItem menuItemOpen;
		private System.Windows.Forms.MenuItem menuItemSave;
		private System.Windows.Forms.MenuItem menuItemSaveAs;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;
		private System.Windows.Forms.RichTextBox richTextBox1;
		private System.Windows.Forms.MenuItem menuItemHelp;
		private System.Windows.Forms.MenuItem menuItemAbout;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button buttonNew;
		private System.Windows.Forms.Button buttonOpen;
		private System.Windows.Forms.Button buttonSave;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.MenuItem menuItemEdit;
		private System.Windows.Forms.MenuItem menuItemCopy;
		private System.Windows.Forms.MenuItem menuItemCut;
		private System.Windows.Forms.MenuItem menuItemPaste;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItemUndo;
		private System.Windows.Forms.MenuItem menuItemSelectAll;
		private System.Windows.Forms.MenuItem menuItemDelete;
		private System.Windows.Forms.Button buttonUndo;
		private System.Windows.Forms.Button buttonCut;
		private System.Windows.Forms.Button buttonCopy;
		private System.Windows.Forms.Button buttonPaste;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(WinForm));
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItemFile = new System.Windows.Forms.MenuItem();
			this.menuItemNew = new System.Windows.Forms.MenuItem();
			this.menuItemOpen = new System.Windows.Forms.MenuItem();
			this.menuItemSave = new System.Windows.Forms.MenuItem();
			this.menuItemSaveAs = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItemEdit = new System.Windows.Forms.MenuItem();
			this.menuItemUndo = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItemCopy = new System.Windows.Forms.MenuItem();
			this.menuItemCut = new System.Windows.Forms.MenuItem();
			this.menuItemPaste = new System.Windows.Forms.MenuItem();
			this.menuItemSelectAll = new System.Windows.Forms.MenuItem();
			this.menuItemHelp = new System.Windows.Forms.MenuItem();
			this.menuItemAbout = new System.Windows.Forms.MenuItem();
			this.menuItemDelete = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			this.richTextBox1 = new System.Windows.Forms.RichTextBox();
			this.panel1 = new System.Windows.Forms.Panel();
			this.buttonPaste = new System.Windows.Forms.Button();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.buttonCopy = new System.Windows.Forms.Button();
			this.buttonCut = new System.Windows.Forms.Button();
			this.buttonUndo = new System.Windows.Forms.Button();
			this.buttonSave = new System.Windows.Forms.Button();
			this.buttonOpen = new System.Windows.Forms.Button();
			this.buttonNew = new System.Windows.Forms.Button();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItemFile,
						this.menuItemEdit,
						this.menuItemHelp});
			// 
			// menuItemFile
			// 
			this.menuItemFile.Index = 0;
			this.menuItemFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItemNew,
						this.menuItemOpen,
						this.menuItemSave,
						this.menuItemSaveAs,
						this.menuItem6,
						this.menuItem7});
			this.menuItemFile.Text = "File";
			// 
			// menuItemNew
			// 
			this.menuItemNew.Index = 0;
			this.menuItemNew.Text = "New";
			this.menuItemNew.Click += new System.EventHandler(this.menuItemNew_Click);
			// 
			// menuItemOpen
			// 
			this.menuItemOpen.Index = 1;
			this.menuItemOpen.Text = "Open...";
			this.menuItemOpen.Click += new System.EventHandler(this.menuItemOpen_Click);
			// 
			// menuItemSave
			// 
			this.menuItemSave.Index = 2;
			this.menuItemSave.Text = "Save";
			this.menuItemSave.Click += new System.EventHandler(this.menuItemSave_Click);
			// 
			// menuItemSaveAs
			// 
			this.menuItemSaveAs.Index = 3;
			this.menuItemSaveAs.Text = "Save As...";
			this.menuItemSaveAs.Click += new System.EventHandler(this.menuItemSaveAs_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 4;
			this.menuItem6.Text = "-";
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 5;
			this.menuItem7.Text = "Quit";
			this.menuItem7.Click += new System.EventHandler(this.menuItemQuit_Click);
			// 
			// menuItemEdit
			// 
			this.menuItemEdit.Index = 1;
			this.menuItemEdit.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItemUndo,
						this.menuItem4,
						this.menuItemCopy,
						this.menuItemCut,
						this.menuItemPaste,
						this.menuItemSelectAll});
			this.menuItemEdit.Text = "Edit";
			// 
			// menuItemUndo
			// 
			this.menuItemUndo.Index = 0;
			this.menuItemUndo.Text = "Undo";
			this.menuItemUndo.Click += new System.EventHandler(this.menuItemUndo_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 1;
			this.menuItem4.Text = "-";
			// 
			// menuItemCopy
			// 
			this.menuItemCopy.Index = 2;
			this.menuItemCopy.Text = "Copy";
			this.menuItemCopy.Click += new System.EventHandler(this.menuItemCopy_Click);
			// 
			// menuItemCut
			// 
			this.menuItemCut.Index = 3;
			this.menuItemCut.Text = "Cut";
			this.menuItemCut.Click += new System.EventHandler(this.menuItemCut_Click);
			// 
			// menuItemPaste
			// 
			this.menuItemPaste.Index = 4;
			this.menuItemPaste.Text = "Paste";
			this.menuItemPaste.Click += new System.EventHandler(this.menuItemPaste_Click);
			// 
			// menuItemSelectAll
			// 
			this.menuItemSelectAll.Index = 5;
			this.menuItemSelectAll.Text = "Select all";
			this.menuItemSelectAll.Click += new System.EventHandler(this.menuItemSelectAll_Click);
			// 
			// menuItemHelp
			// 
			this.menuItemHelp.Index = 2;
			this.menuItemHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItemAbout});
			this.menuItemHelp.Text = "Help";
			// 
			// menuItemAbout
			// 
			this.menuItemAbout.Index = 0;
			this.menuItemAbout.Text = "About...";
			this.menuItemAbout.Click += new System.EventHandler(this.menuItemAbout_Click);
			// 
			// menuItemDelete
			// 
			this.menuItemDelete.Index = -1;
			this.menuItemDelete.Text = "";
			// 
			// menuItem3
			// 
			this.menuItem3.Index = -1;
			this.menuItem3.Text = "";
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.DefaultExt = "txt";
			this.openFileDialog1.Filter = "txt files (*.txt)|*.txt";
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.DefaultExt = "txt";
			this.saveFileDialog1.Filter = "txt files (*.txt)|*.txt";
			// 
			// richTextBox1
			// 
			this.richTextBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.richTextBox1.Location = new System.Drawing.Point(8, 32);
			this.richTextBox1.Name = "richTextBox1";
			this.richTextBox1.Size = new System.Drawing.Size(296, 144);
			this.richTextBox1.TabIndex = 2;
			this.richTextBox1.Text = "";
			this.richTextBox1.TextChanged += new System.EventHandler(this.richTextBox1_TextChanged);
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.buttonPaste);
			this.panel1.Controls.Add(this.buttonCopy);
			this.panel1.Controls.Add(this.buttonCut);
			this.panel1.Controls.Add(this.buttonUndo);
			this.panel1.Controls.Add(this.buttonSave);
			this.panel1.Controls.Add(this.buttonOpen);
			this.panel1.Controls.Add(this.buttonNew);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Top;
			this.panel1.Location = new System.Drawing.Point(0, 0);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(312, 24);
			this.panel1.TabIndex = 3;
			// 
			// buttonPaste
			// 
			this.buttonPaste.ImageIndex = 6;
			this.buttonPaste.ImageList = this.imageList1;
			this.buttonPaste.Location = new System.Drawing.Point(152, 0);
			this.buttonPaste.Name = "buttonPaste";
			this.buttonPaste.Size = new System.Drawing.Size(24, 23);
			this.buttonPaste.TabIndex = 10;
			this.buttonPaste.Click += new System.EventHandler(this.menuItemCopy_Click);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Silver;
			// 
			// buttonCopy
			// 
			this.buttonCopy.ImageIndex = 5;
			this.buttonCopy.ImageList = this.imageList1;
			this.buttonCopy.Location = new System.Drawing.Point(128, 0);
			this.buttonCopy.Name = "buttonCopy";
			this.buttonCopy.Size = new System.Drawing.Size(24, 23);
			this.buttonCopy.TabIndex = 9;
			this.buttonCopy.Click += new System.EventHandler(this.menuItemCopy_Click);
			// 
			// buttonCut
			// 
			this.buttonCut.ImageIndex = 4;
			this.buttonCut.ImageList = this.imageList1;
			this.buttonCut.Location = new System.Drawing.Point(104, 0);
			this.buttonCut.Name = "buttonCut";
			this.buttonCut.Size = new System.Drawing.Size(24, 23);
			this.buttonCut.TabIndex = 8;
			this.buttonCut.Click += new System.EventHandler(this.menuItemCut_Click);
			// 
			// buttonUndo
			// 
			this.buttonUndo.ImageIndex = 3;
			this.buttonUndo.ImageList = this.imageList1;
			this.buttonUndo.Location = new System.Drawing.Point(80, 0);
			this.buttonUndo.Name = "buttonUndo";
			this.buttonUndo.Size = new System.Drawing.Size(24, 23);
			this.buttonUndo.TabIndex = 7;
			this.buttonUndo.Click += new System.EventHandler(this.menuItemUndo_Click);
			// 
			// buttonSave
			// 
			this.buttonSave.ImageIndex = 2;
			this.buttonSave.ImageList = this.imageList1;
			this.buttonSave.Location = new System.Drawing.Point(48, 0);
			this.buttonSave.Name = "buttonSave";
			this.buttonSave.Size = new System.Drawing.Size(24, 23);
			this.buttonSave.TabIndex = 6;
			this.buttonSave.Click += new System.EventHandler(this.menuItemSave_Click);
			// 
			// buttonOpen
			// 
			this.buttonOpen.ImageIndex = 1;
			this.buttonOpen.ImageList = this.imageList1;
			this.buttonOpen.Location = new System.Drawing.Point(24, 0);
			this.buttonOpen.Name = "buttonOpen";
			this.buttonOpen.Size = new System.Drawing.Size(24, 23);
			this.buttonOpen.TabIndex = 5;
			this.buttonOpen.Click += new System.EventHandler(this.menuItemOpen_Click);
			// 
			// buttonNew
			// 
			this.buttonNew.ImageIndex = 0;
			this.buttonNew.ImageList = this.imageList1;
			this.buttonNew.Location = new System.Drawing.Point(0, 0);
			this.buttonNew.Name = "buttonNew";
			this.buttonNew.Size = new System.Drawing.Size(24, 23);
			this.buttonNew.TabIndex = 4;
			this.buttonNew.Click += new System.EventHandler(this.menuItemNew_Click);
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(8, 14);
			this.ClientSize = new System.Drawing.Size(312, 186);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.richTextBox1);
			this.Font = new System.Drawing.Font("Courier New", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.Menu = this.mainMenu1;
			this.Name = "WinForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Editor";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.WinForm_Closing);
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		// Form Members
		private string filename="";
		public string Filename {
			get { return filename; }
			set {
				filename=value;
				Text="Editor "+filename;
			}
		}
		private Boolean modified=false;
		public Boolean Modified {
			get {
				if (modified) {
					switch (MessageBox.Show("Text Modified. Save modifications ?","Confirmation",MessageBoxButtons.YesNoCancel,MessageBoxIcon.Question)) {
						case DialogResult.Yes: {
							return !Save();
						}
						case DialogResult.No: {
							return false;
						}
						default: // Cancel
							return true;
					}
				} else {
					return false;
				}
			}
			set {
				if (modified!=value) {
					modified=value;
					if (modified) {
						//this.Text="*";
					}
				}
			}
		}

		private void menuItemNew_Click(object sender, System.EventArgs e)
		{
			if (!Modified) {
				richTextBox1.Text="";
				Filename="";
				Modified=false;
			}
		}

		private void menuItemOpen_Click(object sender, System.EventArgs e)
		{
			if (!Modified) {
				if (openFileDialog1.ShowDialog()==DialogResult.OK) {
					try {
						richTextBox1.LoadFile(openFileDialog1.FileName,RichTextBoxStreamType.PlainText);
						Filename=openFileDialog1.FileName;
						saveFileDialog1.FileName=Filename;
						Modified=false;
					} catch (Exception ex) {
						MessageBox.Show(ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Warning);
					}
				}
			}
		}

		private void menuItemSaveAs_Click(object sender, System.EventArgs e)
		{
			SaveAs();
		}

		public Boolean SaveAs()
		{
			if (saveFileDialog1.ShowDialog()==DialogResult.OK) {
				Filename=saveFileDialog1.FileName;
				openFileDialog1.FileName=Filename;
				try {
					richTextBox1.SaveFile(Filename,RichTextBoxStreamType.PlainText);
					Modified=false;
					return true;
				} catch (Exception ex) {
					MessageBox.Show(ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Warning);
					return false;
				}
			} else {
				return false;
			}
		}

		private void WinForm_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (Modified) {
				e.Cancel=true;
			}
		}

		private void menuItemSave_Click(object sender, System.EventArgs e)
		{
			Save();
		}

		public bool Save()
		{
			if (Filename=="") {
				return SaveAs();
			} else {
				try {
					richTextBox1.SaveFile(Filename,RichTextBoxStreamType.PlainText);
					Modified=false;
					return true;
				} catch (Exception ex) {
					MessageBox.Show(ex.Message,"Error",MessageBoxButtons.OK,MessageBoxIcon.Warning);
					return false;
				}
			}
		}

		private void richTextBox1_TextChanged(object sender, System.EventArgs e)
		{
			Modified=true;
		}

		private void menuItemAbout_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show("TXTEditor 2oo3 for Borland C#Builder 1.0 by StJo");
		}

		private void menuItemUndo_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Undo();
		}

		private void menuItemCopy_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Copy();
		}

		private void menuItemCut_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Cut();
		}

		private void menuItemPaste_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Paste();
		}

		private void menuItemSelectAll_Click(object sender, System.EventArgs e)
		{
			richTextBox1.SelectAll();
		}

		private void menuItemQuit_Click(object sender, System.EventArgs e)
		{
			Close();
		}
	}
}
